import { NextRequest, NextResponse } from 'next/server';
import { pageStore } from '@/lib/data-store';

export async function GET() {
  try {
    const pages = await pageStore.getAll();
    return NextResponse.json({ success: true, data: pages });
  } catch (error) {
    return NextResponse.json({ success: false, error: 'Failed to fetch pages' }, { status: 500 });
  }
}

export async function POST(request: NextRequest) {
  try {
    const data = await request.json();
    const page = await pageStore.create(data);
    return NextResponse.json({ success: true, data: page });
  } catch (error) {
    return NextResponse.json({ success: false, error: 'Failed to create page' }, { status: 500 });
  }
}